#include <p30fxxxx.h>
#include <outcompare.h>

/********************************************************************
*    Function Name:  ReadRegOC2		                            *
*    Description:    In Non PWM Mode, this function reads the OCRS  *
*                    reg or OCR reg based on input parameter        *
*    Parameters:     char reg                                       *
*    Return Value:   unsigned int OCRS (if reg is 0)                *
*                    or OCR (if reg is 1)                           *
********************************************************************/

unsigned int ReadRegOC2(char reg)
{   
    
    /* check if OC is in NON_PWM Mode */
    if((OC2CONbits.OCM & 0x06) != 0x06) 
    {                                                    
        if(reg)
        {       
            return OC2R; /* Output Compare main Register */
            
        }     
        return OC2RS;    /* Output Compare Secondary Register */
    }  
    return -1;  
}
